#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>

typedef unsigned char byte;
typedef unsigned int  uint;

enum
{
   notFound = 1000,
   badType,
   badBits,    
   badData,    
};

class Targa
{
public:
   Targa();
   Targa(char *name);

   int Load(char *name);
   void Free(void)          {delete [] data;}
   void Reset(void);
   int LastError(void)      {return lastError;}
   int Width(void)          {return width;}
   int Height(void)         {return height;}
   int Bits(void)           {return bits;}
   byte *Data(void)         {return data;}
   byte operator[](int ndx) {return data[ndx];}

private:
   int Error(int errNum, FILE *strm);
   int CheckSize(int x);
   byte *GetRGB(FILE *strm, int size);
   byte *GetRGBA(FILE *strm, int size);
   byte *GetGray(FILE *strm, int size);
   byte *GrabData(FILE *strm, int size);

   int lastError;
   int bits;
   int width;
   int height;
   byte *data;
};



static int size = 0; 

Targa::Targa()
{
   lastError = 0;
   bits = width = height = size = 0; 
   data = 0;
}

Targa::Targa(char *name)
{
   lastError = 0;
   bits = width = height = size = 0; 
   data = 0;

   Load(name);
}

int Targa::Load(char *name)
{
   byte type[4];
   byte info[7];
   FILE *iFile;

   if (!(iFile = fopen(name, "r+bt")))
      return Error(notFound, 0);

   fread(&type, sizeof(byte), 3, iFile); // read in colormap info and image type, byte 0 ignored
   fseek(iFile, 12, SEEK_SET); // seek past the header and useless info
   fread(&info, sizeof(byte), 6, iFile);
   fseek(iFile, type[0], SEEK_CUR); // skip past image identification

   if (type[1] != 0 || (type[2] != 2 && type[2] != 3))
      return Error (badType, iFile);

   width = info[0] + info[1] * 256; 
   height = info[2] + info[3] * 256;
   bits =	info[4]; 

   size = width * height; 

   // make sure we are loading a supported type 
   if (bits != 32 && bits != 24 && bits != 8)
      return Error(badBits, iFile);

   data = GrabData(iFile, size);

   // no image data 
   if (data == 0)
      return Error(badData, iFile);

   fclose(iFile);

   return 1;
}

void Targa::Reset(void)
{
   delete [] data;
   lastError = 0;
   bits = width = height = size = 0; 
   data = 0;
}

int Targa::Error(int errNum, FILE *strm)
{
   lastError = errNum;

   if (strm)
      fclose(strm);

   return 0;
}  

byte *Targa::GetRGBA(FILE *strm, int size)
{
   byte *rgba;
   byte temp;
   int bread;
   int i;

   rgba = new byte[size * 4]; 

   if (rgba == 0)
      return 0;

   bread = fread(rgba, sizeof(byte), size * 4, strm); 

   if (bread != size * 4)
   {
      delete [] rgba;
      return 0;
   }

   for (i = 0; i < size * 4; i += 4 )
   {
      temp = rgba[i];
      rgba[i] = rgba[i + 2];
   rgba[i + 2] = temp;
   }

   return rgba;
}

byte *Targa::GetRGB(FILE *strm, int size)
{
   byte *rgb;
   byte temp;
   int bread;
   int i;

   rgb = new byte[size * 3]; 

   if (rgb == 0)
      return 0;

   bread = fread (rgb, sizeof(byte), size * 3, strm);

   if (bread != size * 3)
   {
      delete [] rgb;
      return 0;
   }

   for (i = 0; i < size * 3; i += 3)
   {
      temp = rgb[i];
      rgb[i] = rgb[i + 2];
      rgb[i + 2] = temp;
   }

   return rgb;
}

byte *Targa::GetGray(FILE *strm, int size)
{
   byte *grayData;
   int bread;

   grayData = new byte[size];

   if (grayData == 0)
      return 0;

   bread = fread(grayData, sizeof(byte), size, strm);

   if (bread != size)
   {
      delete [] grayData;
      return 0;
   }

   return grayData;
}

byte *Targa::GrabData(FILE *strm, int size)
{
   if (bits == 32)
      return GetRGBA (strm, size);
   else if (bits == 24)
      return GetRGB (strm, size);	
   else if (bits == 8)
      return GetGray (strm, size);
   
   return 0;
}

